# Leveraging Unlabeled Data to Track Memorization

## Requirements
We conducted experiments under:
- python 3.7.10
- torch 1.7.1
- torchvision 0.8.2
- cuda 10.1
- jupyter-notebook 6.1.5
- ipython 7.19.0
- 1 Nvidia Titan X Maxwell GPU

## Description of files
* datasets.py: the code to get data loader for a given batch size, training set size and level of label noise.
* models folder: the folder that contains the neural network configurations that are used.
* experiments.py: the code to train the models and compute susceptibility to noisy labels in each epoch.
* results.ipynb: the code to plot figures after the execution of experiments.py is finished.

## Example 
To train a resnet on the CIFAR-10 dataset with 50% label noise level, batch size=128, for 200 epochs run the following command:

```
python3 experiments.py --model resnet --filename <filename> --modelfilename <modelfilename>
```
The model is saved in ./checkpoint/ directoty and the results are saved in ./results/ directory.